@extends('layouts.admin.app')

@section('title', translate('Contact us list'))

@section('content')
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="{{asset('public/assets/admin/img/icons/banner.png')}}" alt="">
                <span class="page-header-title">
                    {{translate('Contact List')}}
                </span>
            </h2>
        </div>
        <div class="row g-2">
            <div class="col-12">
                <div class="card">
                    <div class="card-top px-card pt-4">
                        <div class="row align-items-center gy-2">
                            <div class="col-sm-4 col-md-6 col-lg-8">
                                <h5 class="d-flex align-items-center gap-2 mb-0">
                                    {{translate('Contact_Us_List')}}
                                    <span class="badge badge-soft-dark rounded-50 fz-12">{{ $contact_us->total() }}</span>
                                </h5>
                            </div>
                            <div class="col-sm-8 col-md-6 col-lg-4">
                                <form action="{{ url()->current() }}" method="GET">
                                    <div class="input-group">
                                        <input type="search" name="search" value="{{ $search ?? '' }}" class="form-control" placeholder="{{translate('Search_by_Title')}}" required autocomplete="off">
                                        <div class="input-group-append">
                                            <button type="submit" class="btn btn-primary">{{translate('Search')}}</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="py-4">
                        <div class="table-responsive datatable-custom">
                            <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                                <thead class="thead-light">
                                    <tr>
                                        <th>{{translate('SL')}}</th>
                                        <th>{{translate('Full Name')}}</th>
                                        <th>{{translate('Email')}}</th>
                                        <th>{{translate('Mobile No')}}</th>
                                        <th>{{translate('Comment')}}</th>
                                        <th>{{translate('Date')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($contact_us as $key => $contactus)
                                        <tr>
                                            <td>{{$contact_us->firstItem() + $key }}</td>
                                            <td>{{ $contactus->fullname }}</td>
                                            <td>{{ $contactus->email }}</td>
                                            <td>{{ $contactus->contact_number }}</td>
                                            <td>
                                                <span class="short-comment">
                                                    {{ \Illuminate\Support\Str::limit($contactus->comment, 20) }}
                                                </span>
                                                @if(strlen($contactus->comment) > 20)
                                                    <a href="javascript:void(0);" class="read-more" data-full="{{ $contactus->comment }}">Read more</a>
                                                @endif
                                            </td>
                                            <td>{{ $contactus->created_at }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="table-responsive mt-4 px-3">
                            <div class="d-flex justify-content-lg-end">
                                {!! $contact_us->links() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
<script>
document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.read-more').forEach(function(link) {
        link.addEventListener('click', function () {
            const fullComment = this.getAttribute('data-full');
            this.previousElementSibling.textContent = fullComment;
            this.remove(); // hide the "Read more" link
        });
    });
});
</script>