@extends('layouts.admin.app')

@section('title', translate('Banner list'))

@section('content')
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="{{asset('public/assets/admin/img/icons/banner.png')}}" alt="">
                <span class="page-header-title">
                    {{translate('Home_Banner_Setup')}}
                </span>
            </h2>
        </div>

        <div class="row g-2">
            <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                <a href="{{ route('admin.banner-add-update') }}" class="btn btn-primary">
                    {{ translate('Add Banner') }}
                </a>
            </div>
        </div>

        <div class="row g-2">
            <div class="col-12">
                <div class="card">
                    <div class="card-top px-card pt-4">
                        <div class="row align-items-center gy-2">
                            <div class="col-sm-4 col-md-6 col-lg-8">
                                <h5 class="d-flex align-items-center gap-2 mb-0">
                                    {{translate('Banner_List')}}
                                    <span class="badge badge-soft-dark rounded-50 fz-12">{{ $banners->total() }}</span>
                                </h5>
                            </div>
                            <div class="col-sm-8 col-md-6 col-lg-4">
                                <form action="{{ url()->current() }}" method="GET">
                                    <div class="input-group">
                                        <input type="search" name="search" value="{{ $search ?? '' }}" class="form-control" placeholder="{{translate('Search_by_Title')}}" required autocomplete="off">
                                        <div class="input-group-append">
                                            <button type="submit" class="btn btn-primary">{{translate('Search')}}</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="py-4">
                        <div class="table-responsive datatable-custom">
                            <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                                <thead class="thead-light">
                                    <tr>
                                        <th>{{translate('SL')}}</th>
                                        <th>{{translate('Banner_Image')}}</th>
                                        <th>{{translate('Title')}}</th>
                                        <th>{{translate('status')}}</th>
                                        <th class="text-center">{{translate('action')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($banners as $key => $banner)
                                        <tr>
                                            <td>{{ $banners->firstItem() + $key }}</td>
                                            <td><img class="img-vertical-150" src="{{ asset('storage/app/public/' . $banner->image) }}" alt="{{ translate('banner image') }}"></td>
                                            <td>{{ $banner->title }}</td>
                                            <td>
                                                <label class="switcher">
                                                    <input class="switcher_input status-change" type="checkbox" {{ $banner->status ? 'checked' : '' }}
                                                        data-url="{{ route('admin.home-banner-status', [$banner->id, $banner->status ? 0 : 1]) }}">
                                                    <span class="switcher_control"></span>
                                                </label>
                                            </td>
                                            <td class="text-center">
                                                <a class="btn btn-outline-info btn-sm" href="{{ route('admin.banner-add-update', ['id' => $banner->id]) }}">
                                                    <i class="tio-edit"></i>
                                                </a>
                                                <form action="{{ route('admin.banner-soft-delete', [$banner->id]) }}" method="POST" style="display:inline-block" id="delete-form-{{$banner->id}}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="button" class="btn btn-outline-danger btn-sm" onclick="if(confirm('{{translate('Want to delete this banner?')}}')) document.getElementById('delete-form-{{$banner->id}}').submit();">
                                                        <i class="tio-delete"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <div class="table-responsive mt-4 px-3">
                            <div class="d-flex justify-content-lg-end">
                                {!! $banners->links() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
