<?php

namespace App\Http\Controllers\Api\V1;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Str;
use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use App\Model\Order;
use App\User;


class OrderPaymentController extends Controller
{
    public function __construct(
        private User            $user,
        private Order           $order,
    ){}

    // Cashfree Configuration
    const CASHFREE_APP_ID = '946395381c8f448dab3e44edaf593649';
    const CASHFREE_SECRET_KEY = 'cfsk_ma_prod_59db70c409884633080beb22a196c7a4_1f475165';
    const CASHFREE_GATEWAY_URL = 'https://api.cashfree.com/pg/orders';
    const CASHFREE_PAYMENT_URL = 'https://devn.rglabs.net/food_delivery/api/v1/payment/cashfree_checkout';
    const CASHFREE_RETURN_URL = 'https://devn.rglabs.net/food_delivery/api/v1/payment/cashfree-return/';
    const CASHFREE_NOTIFY_URL = 'https://devn.rglabs.net/food_delivery/api/v1/payment/cashfree-notify/';
    

    public function cashfreeRequest(Request $request) {
        \Log::info("cashfreeRequest-". json_encode($request->all()));
        \Log::info("cashfreeRequestHeader-". json_encode(getallheaders()));

        // $this->validate($request,[
        //     'user_id' => 'required',
        //     'order_id' => 'required',
        //     'amount'=>'required'
        // ]);

        date_default_timezone_set('Asia/Kolkata');
        $post = $_POST;
        $order_id = 100000 + $this->order->all()->count() + 1;
 
        $user= DB::table('users')->where('id',$request->user_id)->first();
        $paymentGatwayMethod="";
        if(!empty($request->paymentGatwayMethod)) {
            $paymentGatwayMethod = $request->paymentGatwayMethod;
        } else {
            $paymentGatwayMethod="";
        }

        if(!empty($paymentGatwayMethod) && $paymentGatwayMethod=="CARDS") {
            $payment_methods="cc,dc,ccc";
        } elseif(!empty($paymentGatwayMethod) && $paymentGatwayMethod=="NB") {
            $payment_methods="nb";
        } elseif(!empty($paymentGatwayMethod) && $paymentGatwayMethod=="UPI") {
            $payment_methods="upi";
        } elseif(!empty($paymentGatwayMethod) && $paymentGatwayMethod=="WALLET") {
            $payment_methods="app";
        } else {
            $payment_methods="cc,dc,ccc,upi,nb,app";
        }

        if(!empty($user)) {
            $url = 'https://api.cashfree.com/pg/orders';
            // $url  = 'https://sandbox.cashfree.com/pg/orders';
            $headers = [
                "x-client-id: 946395381c8f448dab3e44edaf593649",
                "x-client-secret: cfsk_ma_prod_59db70c409884633080beb22a196c7a4_1f475165",
                "Accept: application/json",
                "Content-Type: application/json",
                "x-api-version: 2023-08-01",
            ];

            $data = [
                "order_amount" => (float)$request->amount,
                "order_currency" => "INR",
                // "order_id" => (string)$order_id,
                "order_id" =>  'MK-'.time().rand(10,99),
                "customer_details" => [
                    "customer_id" => "$request->user_id",
                    "customer_phone" => "$request->mobile",
                    "customer_name" => "$request->name",
                ],
                "order_meta" => [
                    "return_url" => 'https://devn.rglabs.net/food_delivery/api/v1/payment/cashfree-return/'.$order_id,
                    "notify_url" => 'https://devn.rglabs.net/food_delivery/api/v1/payment/cashfree-notify/'.$order_id,
                    "payment_methods" => $payment_methods,
                ],
            ];

            $result=array();
            $msg='';
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            $response = curl_exec($ch);

            if (curl_errno($ch)) {
                $msg= 'Error:' . curl_error($ch);
            } else {
                $result= json_decode($response);
            }
            curl_close($ch);

            if(!empty($result) && $result->order_status=="ACTIVE") {
                $session_id = $result->payment_session_id;
                $raw_data=[];
                $all_header = getallheaders();
                $state = "";
                if(isset($all_header['State'])) {
                    $state = strtoupper($all_header['State']);
                }
                if((empty($state) || $state==1) && isset($all_header['state'])) {
                    $state = strtoupper($all_header['state']);
                }
                if($state==1) {
                    $raw_data['other_state']=$state;
                    $state="";
                    $raw_data['all_header']=json_encode($all_header);
                }
                if(empty($state) || $state==1) {
                    $state="";
                }
       
                // $raw_data['state']=$state;
                // $raw_data['osversion']=isset($all_header['osversion'])?$all_header['osversion']:(isset($all_header['Osversion'])?$all_header['Osversion']:"");
                // $raw_data['versioncode']=isset($all_header['versioncode'])?$all_header['versioncode']:(isset($all_header['Versioncode'])?$all_header['Versioncode']:"");
                // $raw_data['devicetype']=isset($all_header['devicetype'])?$all_header['devicetype']:(isset($all_header['Devicetype'])?$all_header['Devicetype']:"");
                // $raw_data['devicename']=isset($all_header['devicename'])?$all_header['devicename']:(isset($all_header['Devicename'])?$all_header['Devicename']:"");
                // $raw_data['is_playstore_build']=isset($all_header['Isplaystorebuild'])?$all_header['Isplaystorebuild']:(isset($all_header['Is_playstore_build'])?$all_header['Is_playstore_build']:"");
                // $raw_data['manufacturer']=isset($all_header['manufacturer'])?$all_header['manufacturer']:(isset($all_header['Manufacturer'])?$all_header['Manufacturer']:"");
                // $raw_data['devicemodel']=isset($all_header['devicemodel'])?$all_header['devicemodel']:(isset($all_header['Devicemodel'])?$all_header['Devicemodel']:"");
                // $raw_data['appsflyeruserid']=isset($all_header['appsflyeruserid'])?$all_header['appsflyeruserid']:(isset($all_header['Appsflyeruserid'])?$all_header['Appsflyeruserid']:"");
                // $raw_data['latitude']=isset($all_header['Latitude'])?$all_header['Latitude']:(isset($all_header['latitude'])?$all_header['latitude']:"");
                // $raw_data['longitude']=isset($all_header['Longitude'])?$all_header['Longitude']:(isset($all_header['longitude'])?$all_header['longitude']:"");

                $insert_data= array(
                    "order_id" => $order_id,
                    "transaction_id" => $order_id,
                    "paymentstatus" => "pending",
                    "payment_method" => "Cashfree",
                    "order_amount" => $request->amount,
                );
                DB::table('order_transactions')->insert($insert_data);

                // $payment_url='https://devn.rglabs.net/food_delivery/api/v1/payment/cashfree_checkout/'.$session_id."?order_id=".$order_id;

                return Response::json(["status" => 'success',"result"=>$result],200);
                die;
            }
            return Response::json(["status" => 'failed',"message"=>$msg],500);
        }
        return Response::json(["status" => 'failed',"message"=>'User not found'],404);
    }

    public function cashfree_return_url($id=null) {
        if(!empty($id)) {
            $result=array();
            $url = 'https://api.cashfree.com/pg/orders/'."$id/payments";
            $headers = [
                "x-client-id: ".'946395381c8f448dab3e44edaf593649',
                "x-client-secret: ".'cfsk_ma_prod_59db70c409884633080beb22a196c7a4_1f475165',
                "Accept: application/json",
                "x-api-version: 2023-08-01",
            ];

            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($ch);
            if (curl_errno($ch)) {
                echo 'Error:' . curl_error($ch);die;
            } else {
                $result= json_decode($response);
            }
            curl_close($ch);

            if(!empty($result)){
                if(empty($result->code)){
                    $res=$result[0];
                    if($res->payment_status=="SUCCESS") {
                        echo '<h5>SUCCESS</h5>';
                        echo '<p>Money added successfully</p>';
                        echo '<h4>₹'.$res->payment_amount.'</h4>';
                        echo '<small>to your account!</small>';
                        echo '<h6>Transaction ID: '.$res->cf_payment_id.'</h6>';
                        echo '<button>Done</button>';
                        die;
                    } elseif($res->payment_status=="PENDING") {
                        echo '<h5>PENDING</h5>';
                        echo '<p>Your payment status is pending</p>';
                        echo '<h4>₹'.$res->payment_amount.'</h4>';
                        echo '<small>to your account!</small>';
                        echo '<h6>Transaction ID: '.$res->cf_payment_id.'</h6>';
                        echo '<button>Done</button>';
                        die;
                    } elseif($res->payment_status=="USER_DROPPED") {
                        echo '<h5>USER DROPPED</h5>';
                        echo '<p>Your payment is dropped</p>';
                        echo '<h4>₹'.$res->payment_amount.'</h4>';
                        echo '<small>to your account!</small>';
                        echo '<h6>Transaction ID: '.$res->cf_payment_id.'</h6>';
                        echo '<button>Done</button>';
                        die;
                    } elseif($res->payment_status=="FAILED") {
                        echo '<h5>FAILED</h5>';
                        echo '<p>Your payment is dropped</p>';
                        echo '<h4>₹'.$res->payment_amount.'</h4>';
                        echo '<small>to your account!</small>';
                        echo '<h6>Transaction ID: '.$res->cf_payment_id.'</h6>';
                        if(!empty($res->error_details) && !empty($res->error_details->error_description)) {
                            echo '<i>'.$res->error_details->error_description.'</i><br>';
                        }
                        echo '<button>Done</button>';
                        die;
                    }
                } else {
                    echo '<h5>FAILED</h5>';
                    echo '<p>Payment unsuccessful</p>';
                    echo '<h4></h4>';
                    echo '<small>Something went wrong</small>';
                    echo '<h6>Please try again</h6>';
                    echo '<button>Try again</button>';
                    die;
                }
            }
        }
        echo '<h5>cancelTransaction</h5>';
        echo '<p>Transaction Cancelled</p>';
        echo '<h4></h4>';
        echo '<small></small>';
        echo '<h6>Please try again</h6>';
        echo '<button>Try again</button>';
        die;
    }

    public function cashfree_notify_url(Request $request,$id) {
        date_default_timezone_set('Asia/Kolkata');
        \Log::info('cashfree_notify_url: '.json_encode($request->all())); //die;
        \Log::info('cashfree_notify_url_header: '.json_encode($request->header())); //die;
        $headers = $request->header();

        // $result='{"data":{"order":{"order_id":"CFP-173211041555","order_amount":100,"order_currency":"INR","order_tags":null},"payment":{"cf_payment_id":5114915066992,"payment_status":"SUCCESS","payment_amount":100,"payment_currency":"INR","payment_message":null,"payment_time":"2024-11-20T19:17:25+05:30","bank_reference":null,"auth_id":null,"payment_method":{"upi":{"channel":null,"upi_id":null}},"payment_group":"upi"},"customer_details":{"customer_name":null,"customer_id":"akshat151","customer_email":null,"customer_phone":"8209420306"},"payment_gateway_details":{"gateway_name":"CASHFREE","gateway_order_id":"2188146033","gateway_payment_id":"5114915066992","gateway_status_code":null,"gateway_order_reference_id":"null","gateway_settlement":"CASHFREE"},"payment_offers":null},"event_time":"2024-11-20T19:17:44+05:30","type":"PAYMENT_SUCCESS_WEBHOOK"}';

        $res=$request->all();
        if(!empty($res)) {
            $jsonData=json_encode($res);
            $transaction_id=$id;
            $paymentId=NULL;
            $transaction_row = DB::table('order_transactions')->where('transaction_id', $transaction_id)->where('paymentstatus', 'pending')->first();

            if(!empty($transaction_row)){
                if($res['type']=='PAYMENT_SUCCESS_WEBHOOK' && !empty($res['data'])){
                    if(!empty($res['data']['payment']['payment_status']) && $res['data']['payment']['payment_status']=='SUCCESS'  && !empty($res['data']['order']['order_id']) && $res['data']['order']['order_id']==$transaction_id) {
                        if(!empty($res['data']['payment']['cf_payment_id'])) {
                            $paymentId=$res['data']['payment']['cf_payment_id'];
                        }

                        $payment_method=@$res['data']['payment']['payment_group'];
                        DB::table('order_transactions')->where('transaction_id', $transaction_id)->update(['payment_status' => 'success']);
                        echo "Success: $res";
                        die;
                    } else {
                        DB::table('order_transactions')->where('transaction_id', $transaction_id)->update(['payment_status' => 'failed']);
                        echo 'Fail';
                        die;
                    }
                }
            }
        }
        die('Nothing Happen');
    }
}